/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import org.jetbrains.annotations.Nullable;

public final class BlockEntityTicker {
    private static final Map<class_5321<class_1937>, BlockEntityTicker> TICKERS = new Object2ObjectOpenHashMap();
    private final class_5321<class_1937> levelKey;
    private final Map<class_1923, Entry> blockEntityEntries = new Object2ObjectOpenHashMap();
    private final Map<class_1923, Entry> pendingEntries = new Object2ObjectOpenHashMap();

    private BlockEntityTicker(class_5321<class_1937> levelKey) {
        this.levelKey = levelKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntity(class_2586 entity, class_1937 level, class_1923 chunkPos) {
        BlockEntityTicker ticker;
        if (LootrAPI.isDisabled()) {
            return;
        }
        class_5321<class_1937> dimension = BlockEntityTicker.getServerDimensionIfValid(level);
        if (dimension == null) {
            return;
        }
        Map<class_5321<class_1937>, BlockEntityTicker> map = TICKERS;
        synchronized (map) {
            ticker = TICKERS.computeIfAbsent(dimension, BlockEntityTicker::new);
        }
        ticker.addEntity(level, entity, chunkPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntity(class_1937 level, class_2586 entity, class_1923 chunkPos) {
        if (!LootrAPI.isWorldBorderSafe(level, chunkPos)) {
            return;
        }
        if (!BlockEntityTicker.isValidEntity(entity)) {
            return;
        }
        Map<class_1923, Entry> map = this.pendingEntries;
        synchronized (map) {
            Entry previousEntry = this.pendingEntries.get(chunkPos);
            if (previousEntry != null) {
                previousEntry.entityPositions.add(entity.method_11016());
            } else {
                HashSet<class_2338> entityPositions = new HashSet<class_2338>();
                entityPositions.add(entity.method_11016());
                Entry entry = new Entry(chunkPos, entityPositions);
                this.pendingEntries.put(chunkPos, entry);
            }
        }
    }

    private static boolean isValidEntity(class_2586 entity) {
        if (LootrTags.BlockEntity.isTagged(entity, LootrTags.BlockEntity.CONVERT_BLACKLIST)) {
            return false;
        }
        if (entity instanceof ILootrBlockEntity || LootrAPI.resolveBlockEntity(entity) instanceof ILootrBlockEntity) {
            return false;
        }
        ILootrDataAdapter<class_2586> adapter = LootrAPI.getAdapter(entity);
        return adapter != null;
    }

    public static boolean isValidEntityFull(class_2586 entity) {
        Set<class_1923> loadedChunks;
        if (LootrAPI.isDisabled()) {
            return false;
        }
        if (LootrTags.BlockEntity.isTagged(entity, LootrTags.BlockEntity.CONVERT_BLACKLIST)) {
            return false;
        }
        class_1937 level = entity.method_10997();
        class_2338 pos = entity.method_11016();
        if (level == null) {
            return false;
        }
        if (level.method_8608() || level.method_8503() == null || LootrAPI.getServer() == null || !(level instanceof class_3218)) {
            return false;
        }
        class_3218 serverLevel = (class_3218)level;
        if (entity instanceof ILootrBlockEntity || LootrAPI.resolveBlockEntity(entity) instanceof ILootrBlockEntity) {
            return false;
        }
        MinecraftServer server = level.method_8503();
        if (!server.method_18854()) {
            LootrAPI.LOG.error("Called isValidEntityFull on a non-server thread for {} in {}", (Object)entity, (Object)level.method_27983());
            return false;
        }
        if (LootrAPI.isDimensionBlocked((class_5321<class_1937>)serverLevel.method_27983())) {
            return false;
        }
        if (!LootrAPI.isWorldBorderSafe(level, pos)) {
            return false;
        }
        if (LootrAPI.replacementBlockState(entity.method_11010()) == null) {
            return false;
        }
        ILootrDataAdapter<class_2586> adapter = LootrAPI.getAdapter(entity);
        if (adapter == null) {
            return false;
        }
        class_5321<class_52> lootTable = adapter.getLootTable(entity);
        if (lootTable == null) {
            return false;
        }
        if (LootrAPI.isLootTableBlacklisted(lootTable)) {
            return false;
        }
        Entry testEntry = new Entry(new class_1923(pos), Set.of(pos));
        return testEntry.getChunkLoadStatus(serverLevel, loadedChunks = LoadedChunks.getLoadedChunks((class_5321<class_1937>)level.method_27983())) == ChunkLoadStatus.COMPLETE;
    }

    public static void onServerTick(MinecraftServer server) {
        if (LootrAPI.isDisabled()) {
            return;
        }
        for (BlockEntityTicker ticker : TICKERS.values()) {
            class_3218 level = server.method_3847(ticker.levelKey);
            if (level == null) continue;
            ticker.onServerLevelTick(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerLevelTick(class_3218 level) {
        Set<class_1923> loadedChunks = LoadedChunks.getLoadedChunks((class_5321<class_1937>)level.method_27983());
        Iterator<Entry> iterator = this.blockEntityEntries.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            switch (entry.getChunkLoadStatus(level, loadedChunks).ordinal()) {
                case 0: {
                    iterator.remove();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    BlockEntityTicker.replaceEntitiesInChunk(level, entry);
                    iterator.remove();
                }
            }
        }
        Map<class_1923, Entry> map = this.pendingEntries;
        synchronized (map) {
            for (Entry entry : this.pendingEntries.values()) {
                this.blockEntityEntries.merge(entry.chunkPos, entry, (entry1, entry2) -> {
                    entry1.entityPositions.addAll(entry2.entityPositions);
                    return entry1;
                });
            }
            this.pendingEntries.clear();
        }
    }

    private static boolean checkStructureValidity(class_3218 level, class_1923 chunkPos, class_2338 position) {
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return true;
        }
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        class_6885.class_6888 structureBlacklist = registry.method_46735(LootrTags.Structure.STRUCTURE_BLACKLIST);
        class_6885.class_6888 structureWhitelist = registry.method_46735(LootrTags.Structure.STRUCTURE_WHITELIST);
        if (structureBlacklist.method_40247() != 0) {
            return !LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_BLACKLIST, position);
        }
        if (structureWhitelist.method_40247() != 0) {
            return !LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_WHITELIST, position);
        }
        return true;
    }

    private static void replaceEntitiesInChunk(class_3218 level, Entry entry) {
        for (class_2338 entityPos : entry.entityPositions()) {
            class_2680 stateAt;
            class_2680 replacement;
            ILootrDataAdapter<class_2586> adapter;
            class_2586 blockEntity;
            if (!BlockEntityTicker.checkStructureValidity(level, entry.chunkPos(), entityPos) || LootrAPI.resolveBlockEntity(blockEntity = level.method_8321(entityPos)) instanceof ILootrBlockEntity || (adapter = LootrAPI.getAdapter(blockEntity)) == null) continue;
            class_5321<class_52> table = adapter.getLootTable(blockEntity);
            long seed = adapter.getLootSeed(blockEntity);
            if (table == null) {
                if (!LootrAPI.shouldWarnNoLootTables()) continue;
                LootrAPI.LOG.warn("Potential block entity {} has no loot table in {} ({})", (Object)blockEntity, (Object)level.method_27983(), (Object)entityPos);
                continue;
            }
            if (LootrAPI.isLootTableBlacklisted(table) || (replacement = LootrAPI.replacementBlockState(stateAt = level.method_8320(entityPos))) == null) continue;
            BlockEntityTicker.replaceEntity(level, entityPos, adapter, blockEntity, replacement, table, seed);
        }
    }

    private static void replaceEntity(class_3218 level, class_2338 entityPos, ILootrDataAdapter<class_2586> adapter, class_2586 be, class_2680 replacement, class_5321<class_52> table, long seed) {
        LootrAPI.preProcess(level, entityPos, be, replacement, table, seed);
        DataToCopy data = PlatformAPI.copySpecificData(be);
        class_1799 itemCopy = class_1799.field_8037;
        if (adapter.hasCopyableComponentsViaItem(be)) {
            itemCopy = new class_1799((class_1935)be.method_11010().method_26204());
            itemCopy.method_57365(be.method_57590());
        }
        adapter.setLootTable(be, null, 0L);
        level.method_8652(entityPos, replacement, 2);
        class_2586 newBlockEntity = level.method_8321(entityPos);
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(newBlockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity) {
            ILootrBlockEntity ibe = iLootrBlockEntity;
            if (!itemCopy.method_7960()) {
                ibe.asBlockEntity().method_58683(itemCopy);
            }
            PlatformAPI.restoreSpecificData(data, newBlockEntity);
            ibe.setLootTableInternal(table, seed);
            if (PlatformAPI.shouldDoInitialSave()) {
                ibe.performUpdate();
            }
            LootrAPI.postProcess(level, entityPos, ibe.asBlockEntity(), replacement, table, seed);
        } else {
            LootrAPI.LOG.error("Somehow, replacement result {} is not an ILootrBlockEntity {} at {}", (Object)replacement, (Object)level.method_27983(), (Object)entityPos);
        }
    }

    @Nullable
    private static class_5321<class_1937> getServerDimensionIfValid(class_1937 level) {
        if (LootrAPI.getServer() == null || level.method_8608()) {
            return null;
        }
        class_5321 dimension = level.method_27983();
        if (LootrAPI.isDimensionBlocked((class_5321<class_1937>)dimension)) {
            return null;
        }
        return dimension;
    }

    public record Entry(class_1923 chunkPos, Set<class_2338> entityPositions) {
        public ChunkLoadStatus getChunkLoadStatus(class_3218 level, Set<class_1923> loadedChunks) {
            class_3215 chunkSource = level.method_14178();
            if (!LootrAPI.isWorldBorderSafe((class_1937)level, this.chunkPos) || !chunkSource.method_12123(this.chunkPos.field_9181, this.chunkPos.field_9180)) {
                return ChunkLoadStatus.UNLOADED;
            }
            if (!loadedChunks.contains(this.chunkPos)) {
                return ChunkLoadStatus.NOT_FULLY_LOADED;
            }
            for (int x = this.chunkPos.field_9181 - 2; x <= this.chunkPos.field_9181 + 2; ++x) {
                for (int z = this.chunkPos.field_9180 - 2; z <= this.chunkPos.field_9180 + 2; ++z) {
                    class_1923 pos;
                    if (x == this.chunkPos.field_9181 && z == this.chunkPos.field_9180 || !LootrAPI.isWorldBorderSafe((class_1937)level, pos = new class_1923(x, z)) || loadedChunks.contains(pos)) continue;
                    return ChunkLoadStatus.SURROUNDING_CHUNKS_NOT_LOADED;
                }
            }
            return ChunkLoadStatus.COMPLETE;
        }
    }

    public static enum ChunkLoadStatus {
        UNLOADED,
        SURROUNDING_CHUNKS_NOT_LOADED,
        NOT_FULLY_LOADED,
        COMPLETE;

    }
}

